<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="d-flex mb-3">
        <input type="text" id="searchInput" class="form-control me-2" placeholder="<?php echo e(__('message.movie_title')); ?>" required>
        <input type="text" id="yearInput" class="form-control me-2" placeholder="<?php echo e(__('message.year_of_release')); ?>">
        <select id="typeInput" class="form-control me-2">
            <option value=""><?php echo e(__('message.select_type')); ?></option>
            <option value="movie">Movie</option>
            <option value="series">Series</option>
            <option value="episode">Episode</option>
        </select>
        <button class="btn btn-primary" id="searchButton">
            <?php echo e(__('message.search')); ?>

        </button>
    </div>

    <div id="loadingIndicator" class="text-center my-4" style="display: none;">
        <div class="spinner-border text-primary" role="status">
            <span class="visually-hidden">Loading...</span>
        </div>
    </div>

    <div id="movieListContainer" class="row">
        <div id="movieSearchPlaceholder" class="w-100 d-flex justify-content-center align-items-center" style="height: 300px;">
            <div class="text-center">
                <h2 class="display-6 text-primary fw-bold text-uppercase"><?php echo e(__('message.search_your_movies')); ?></h2>
                <p class="text-muted"><?php echo e(__('message.find_your_movies')); ?></p>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    let currentPage = 1;
    let searchField = '';
    let yearField = '';
    let typeField = '';
    let isLoading = false;
    let hasMoreMovies = true; // NEW FLAG

    $('#searchButton').on('click', function () {
        searchField = $('#searchInput').val();
        yearField = $('#yearInput').val();
        typeField = $('#typeInput').val();

        if (searchField.trim() === '') {
            alert('Please enter a movie title to search.');
            return;
        }

        currentPage = 1;
        hasMoreMovies = true; // RESET FLAG
        $('#movieListContainer').html('');
        $('#movieSearchPlaceholder').hide();
        $('#noMoreMoviesMessage').remove(); // Remove any old message
        loadMovies();
    });

    function loadMovies() {
        if (isLoading || !hasMoreMovies) return;

        isLoading = true;
        $('#loadingIndicator').show();

        $.get("<?php echo e(route('movies.search')); ?>", {
            q: searchField,
            year: yearField,
            type: typeField,
            page: currentPage
        })
        .done(function (data) {
            if (data.length === 0) {
                hasMoreMovies = false;

                // Append message only once
                if (!$('#noMoreMoviesMessage').length) {
                    $('#movieListContainer').append(`
                        <div id="noMoreMoviesMessage" class="col-12 text-center my-4">
                            <p class="text-danger text-uppercase fw-bold">No more movies found.</p>
                        </div>
                    `);
                }
            } else {
                $('#movieListContainer').append(data);
                currentPage++;
            }
        })
        .fail(function () {
            $('#movieListContainer').append(`
                <div class="col-12 text-center text-danger my-4">
                    Failed to load movies. Please try again later.
                </div>
            `);
            hasMoreMovies = false;
        })
        .always(function () {
            isLoading = false;
            $('#loadingIndicator').hide();
        });
    }

    // Infinite scroll
    $(window).on('scroll', function () {
        if (hasMoreMovies && !isLoading && $(window).scrollTop() + $(window).height() >= $(document).height() - 300) {
            loadMovies();
        }
    });

</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>