<?php if(empty($movies) && $nextPage - 1 == 1): ?>
<div class="col-12 d-flex justify-content-center align-items-center" style="height: 300px;">
    <p class="text-uppercase fw-bold text-muted text-center mb-0">
        No movies available
    </p>
</div>
<?php else: ?>

    <?php if(!empty($movies)): ?>
        <?php $__currentLoopData = $movies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $movie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-md-3 mb-4">
            <div class="card h-100 shadow-sm">
                <img 
                    src="" 
                    data-src="<?php echo e($movie['Poster'] !== 'N/A' && @get_headers($movie['Poster'])[0] !== 'HTTP/1.1 404 Not Found' ? $movie['Poster'] : asset('metronic/media/auth/404.png')); ?>" 
                    class="card-img-top lazy img-fluid" 
                    alt="<?php echo e($movie['Title']); ?>"
                    style="height: 300px; object-fit: cover; object-position: center;"
                >
                <div class="card-body">
                    <h6 class="card-title"><?php echo e($movie['Title']); ?></h6>
                    <p class="text-muted"><?php echo e($movie['Year']); ?></p>

                    <?php
                        $isFavourite = in_array($movie['imdbID'], $userFavourites);
                    ?>

                    <button 
                        class="btn btn-outline-<?php echo e($isFavourite ? 'secondary remove-from-favourite' : 'danger add-to-favourite'); ?> btn-sm" 
                        data-imdbid="<?php echo e($movie['imdbID']); ?>"
                        data-title="<?php echo e($movie['Title']); ?>"
                        data-year="<?php echo e($movie['Year']); ?>"
                        data-poster="<?php echo e($movie['Poster']); ?>"
                        data-toggle="tooltip"
                        data-placement="top"
                        title="<?php echo e($isFavourite ? 'Remove from Favourite' : 'Add to Favourite'); ?>"
                        onclick="<?php echo e($isFavourite ? 'removeFromFavourite(this)' : 'addToFavourite(this)'); ?>"
                        style="width: 100%;"
                    >
                        <?php if($isFavourite): ?>
                            <i class="fas fa-heart-broken"></i> Remove from Favourite
                        <?php else: ?>
                            <i class="fas fa-heart"></i> Add to Favourite
                        <?php endif; ?>
                    </button>

                    <button 
                        class="btn btn-sm btn-outline-primary w-100 mt-2" 
                        onclick="showMovieDetail(this)"
                        data-imdbid="<?php echo e($movie['imdbID']); ?>"
                    >
                        <i class="fas fa-info-circle"></i> View Details
                    </button>


                </div>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <script>
            document.querySelectorAll('img.lazy').forEach(img => {
                if ('IntersectionObserver' in window) {
                    let observer = new IntersectionObserver((entries, observer) => {
                        entries.forEach(entry => {
                            if (entry.isIntersecting) {
                                let lazyImg = entry.target;
                                lazyImg.src = lazyImg.dataset.src;
                                lazyImg.classList.remove('lazy');
                                observer.unobserve(lazyImg);
                            }
                        });
                    });
                    observer.observe(img);
                } else {
                    // Fallback: load immediately
                    img.src = img.dataset.src;
                }
            });

            function addToFavourite(movie, fromModal = false) {
                let imdbid = movie.getAttribute('data-imdbid');
                let title = movie.getAttribute('data-title');
                let year = movie.getAttribute('data-year');
                let poster = movie.getAttribute('data-poster');
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                    }
                });

                $.ajax({
                    url: "<?php echo e(route('favourites.add')); ?>",
                    method: 'POST',
                    data: {
                        imdbID: imdbid,
                        title: title,
                        year: year,
                        poster: poster
                    },
                    success: function (response) {
                        alert(response.message);
                        if (fromModal) {
                            toggleFavouriteModalButton(true);
                        } else {
                            $(movie).removeClass('add-to-favourite').addClass('remove-from-favourite');
                            $(movie).attr('data-toggle', 'tooltip');
                            $(movie).attr('data-placement', 'top');
                            $(movie).attr('title', 'Remove from Favourite');
                            $(movie).html('<i class="fas fa-heart-broken"></i> Remove from Favourite');
                            $(movie).attr('onclick', 'removeFromFavourite(this)');
                            $(movie).tooltip('dispose');
                            $(movie).tooltip({
                                title: 'Remove from Favourite',
                                placement: 'top'
                            });
                        }
                    },
                    error: function (xhr) {
                        if (xhr.status === 409) {
                            alert(xhr.responseJSON.message);
                        } else {
                            alert('Something went wrong!');
                        }
                    }
                });
            }

            function removeFromFavourite(button, fromModal = false) {
                let imdbid = button.getAttribute('data-imdbid');
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                    }
                });

                $.ajax({
                    url: "<?php echo e(route('favourites.remove')); ?>", // You'll create this route next
                    method: 'POST',
                    data: {
                        imdbID: imdbid
                    },
                    success: function (response) {
                        alert(response.message);
                        if (fromModal) {
                            toggleFavouriteModalButton(false);
                        } else {
                            $(button).removeClass('remove-from-favourite').addClass('add-to-favourite btn-outline-danger');
                            $(button).attr('data-toggle', 'tooltip');
                            $(button).attr('title', 'Add to Favourite');
                            $(button).html('<i class="fas fa-heart"></i> Add to Favourite');
                            $(button).attr('onclick', 'addToFavourite(this)');
                        }
                    },
                    error: function () {
                        alert('Failed to remove from favourites.');
                    }
                });
            }

            function showMovieDetail(button) {
                let imdbid = button.getAttribute('data-imdbid');
                $('#movieDetailModal').modal('show');
                $('#movieDetailTitle').text('Loading...');
                $('#movieDetailContent').html(`
                    <div class="text-center my-4">
                        <div class="spinner-border text-primary" role="status"></div>
                    </div>
                `);

                $.ajax({
                    url: "<?php echo e(route('movies.detail')); ?>",
                    method: 'GET',
                    data: {
                        i: imdbid,
                        plot: 'full',
                    },
                    success: function(data) {
                        $('#movieDetailTitle').text(data.Title);
                        $('#movieDetailContent').html(`
                            <div class="row">
                                <div class="col-md-4 text-center mb-3">
                                    <img src="${data.Poster !== 'N/A' ? data.Poster : '<?php echo e(asset("metronic/media/auth/404.png")); ?>'}" 
                                        alt="${data.Title}" class="img-fluid rounded shadow-sm">
                                </div>
                                <div class="col-md-8 text-start">
                                    <h5>${data.Title} (${data.Year})</h5>
                                    <p><strong>Director:</strong> ${data.Director}</p>
                                    <p><strong>Genre:</strong> ${data.Genre}</p>
                                    <p><strong>Runtime:</strong> ${data.Runtime}</p>
                                    <p><strong>IMDb Rating:</strong> ${data.imdbRating}</p>
                                    <p><strong>Plot:</strong> ${data.Plot}</p>
                                    <button 
                                        class="btn btn-outline-danger btn-sm w-100 mt-3" 
                                        id="favouriteButtonModal"
                                        data-imdbid="${data.imdbID}"
                                        data-title="${data.Title}"
                                        data-year="${data.Year}"
                                        data-poster="${data.Poster}"
                                    >
                                        <i class="fas fa-heart"></i> Add to Favourite
                                    </button>
                                </div>
                            </div>
                        `);

                        // Check if already favourite
                        $.ajax({
                            url: "<?php echo e(route('favourites.check')); ?>",
                            method: 'POST',
                            data: {
                                imdbID: data.imdbID,
                                _token: '<?php echo e(csrf_token()); ?>'
                            },
                            success: function(response) {
                                toggleFavouriteModalButton(response.isFavourite);
                            }
                        });
                    },
                    error: function() {
                        $('#movieDetailContent').html(`<div class="alert alert-danger">Failed to load movie details.</div>`);
                    }
                });
            }

            function toggleFavouriteModalButton(isFavourite) {
                const btn = $('#favouriteButtonModal');
                if (!btn.length) return;

                if (isFavourite) {
                    btn.removeClass('btn-outline-danger').addClass('btn-outline-secondary');
                    btn.html('<i class="fas fa-heart-broken"></i> Remove from Favourite');
                    btn.off('click').on('click', () => removeFromFavourite(btn[0], true));
                } else {
                    btn.removeClass('btn-outline-secondary').addClass('btn-outline-danger');
                    btn.html('<i class="fas fa-heart"></i> Add to Favourite');
                    btn.off('click').on('click', () => addToFavourite(btn[0], true));
                }
            }

        </script>

    <?php endif; ?>

<?php endif; ?>

