<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Auth;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return redirect()->route('login');
});

// Auth::routes();
Auth::routes(['register' => false]);

Route::get('/home', 'HomeController@index')->name('home');

Route::middleware('auth')->group(function () {
    Route::get('/movies/search', 'MovieController@search')->name('movies.search');
    Route::get('/movies/detail', 'MovieController@detail')->name('movies.detail');

    Route::post('/favourites/add', 'FavouriteController@addToFavourite')->name('favourites.add');
    Route::post('/favourites/remove', 'FavouriteController@removeFromFavourite')->name('favourites.remove');
    Route::get('/favourites', 'FavouriteController@index')->name('favourites.index');
    Route::post('/favourites/check', 'FavouriteController@check')->name('favourites.check');

});

Route::get('lang/{locale}', function ($locale) {
    if (in_array($locale, ['en', 'id'])) {
        session(['locale' => $locale]);
        App::setLocale($locale);
    }
    return redirect()->back();
})->name('locale.switch');


