@extends('layouts.app')

@section('content')
<div class="container">
    <h4 class="mb-4">My Favourite Movies</h4>

    @if($favourites->isEmpty())
        <div class="text-center text-muted text-uppercase fw-bold" style="height: 200px; display: flex; justify-content: center; align-items: center;">
            No favourite movies found.
        </div>
    @else
        <div class="row">
            @foreach($favourites as $movie)
                <div class="col-md-3 mb-4">
                    <div class="card h-100 shadow-sm">
                        <img 
                            src="{{ $movie->poster ?? asset('metronic/media/auth/404.png') }}" 
                            alt="Poster of {{ $movie->title }}" 
                            class="card-img-top img-fluid" 
                            style="height: 300px; object-fit: cover;"
                        >
                        <div class="card-body">
                            <h6 class="card-title">{{ $movie->title }}</h6>
                            <p class="text-muted">{{ $movie->year }}</p>
                            <button 
                                type="button" 
                                class="btn btn-sm btn-outline-danger w-100 remove-from-favourite" 
                                data-imdbid="{{ $movie->imdbID }}"
                                onclick="removeFromFavourite(this)"
                            >
                                <i class="fas fa-heart-broken"></i> Remove from Favourite
                            </button>

                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    @endif
</div>
@endsection

@section('scripts')
<script>
    function removeFromFavourite(button) {
        const imdbID = button.getAttribute('data-imdbid');

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            }
        });

        $.ajax({
            url: "{{ route('favourites.remove') }}",
            method: 'POST',
            data: { imdbID: imdbID },
            success: function(response) {
                alert(response.message);

                // Remove the card element
                const card = button.closest('.col-md-3');
                if (card) card.remove();

                // Optional: Show "no favourites" if empty
                if (document.querySelectorAll('.col-md-3').length === 0) {
                    document.querySelector('.row').innerHTML = `
                        <div class="text-center text-muted text-uppercase fw-bold" style="height: 200px; display: flex; justify-content: center; align-items: center;">
                            No favourite movies found.
                        </div>`;
                }
            },
            error: function() {
                alert('Failed to remove from favourites.');
            }
        });
    }
</script>

@endsection
