<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use GuzzleHttp\Client;

class MovieController extends Controller
{

    public function search(Request $request)
    {
        $search = $request->query('q');
        $year = $request->query('year');
        $type = $request->query('type');
        $page = $request->query('page', 1);

        $client = new Client();
        $response = $client->get('http://www.omdbapi.com/', [
            'query' => [
                'apikey' => config('services.omdb.key'),
                's' => $search,
                'page' => $page,
                'type' => $type,
                'y' => $year,
            ]
        ]);

        $body = json_decode($response->getBody(), true);
        $movies = $body['Search'] ?? [];

        if ($request->ajax()) {
            $userFavourites = auth()->check()
                                ? \App\Favourite::where('user_id', auth()->id())->pluck('imdbID')->toArray()
                                : [];
            return view('partials.movie-list', [
                'movies' => $movies,
                'nextPage' => $page + 1,
                'search' => $search,
                'userFavourites' => $userFavourites,
            ]);
        }

        return view('movies.index');
    }

    public function detail(Request $request)
    {
        $i = $request->query('i');
        $plot = $request->query('plot');

        $client = new Client();
        $response = $client->get('http://www.omdbapi.com/', [
            'query' => [
                'apikey' => config('services.omdb.key'),
                'i' => $i,
                'plot' => $plot,
            ]
        ]);

        $body = json_decode($response->getBody(), true);

        if ($request->ajax()) {
            return response()->json($body);
        }

    }

}
