<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Favourite;

class FavouriteController extends Controller
{

    public function index()
    {
        $favourites = Favourite::where('user_id', auth()->id())->get();

        return view('favourites.index', compact('favourites'));
    }

    public function addToFavourite(Request $request)
    {
        $request->validate([
            'imdbID' => 'required|string',
            'title' => 'required|string',
            'year' => 'required|string',
            'poster' => 'nullable|string',
        ]);

        // Check if already exists
        $exists = Favourite::where('user_id', auth()->id())
            ->where('imdbID', $request->imdbID)
            ->exists();

        if ($exists) {
            return response()->json(['message' => 'Already in favourites.'], 409);
        }

        Favourite::create([
            'user_id' => auth()->id(),
            'imdbID'  => $request->imdbID,
            'title'   => $request->title,
            'year'    => $request->year,
            'poster'  => $request->poster,
        ]);

        return response()->json(['message' => 'Added to favourites.']);
    }

    public function removeFromFavourite(Request $request)
    {
        $request->validate([
            'imdbID' => 'required|string'
        ]);

        $favourite = \App\Favourite::where('user_id', auth()->id())
            ->where('imdbID', $request->imdbID)
            ->first();

        if ($favourite) {
            $favourite->delete();
            return response()->json(['message' => 'Removed from favourites.']);
        }

        return response()->json(['message' => 'Favourite not found.'], 404);
    }

    public function check(Request $request)
    {
        $exists = \App\Favourite::where('user_id', auth()->id())
            ->where('imdbID', $request->imdbID)
            ->exists();

        return response()->json(['isFavourite' => $exists]);
    }



}
